<x-app-layout>
    <x-slot name="header">
        Category
    </x-slot>

    <div class="row row-sm">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <a href="{{ route('admin.category.create', $type) }}" class="btn btn-primary">Add New</a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="datatable" class="table table-bordered text-nowrap border-bottom">
                            <thead>
                                <tr>
                                    <th class="border-bottom-0">Category</th>
                                    <th class="border-bottom-0">{{ucfirst($relationMap[$type])}}</th>
                                    <th class="border-bottom-0">Status</th>
                                    <th class="border-bottom-0">created At</th>
                                    <th class="border-bottom-0">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($categories as $category)
                                <tr>
                                    <td>
                                        <div class="d-flex">
                                            @isset($category->image)
                                            <div class="avatar-md me-3">
                                                <img src="{{ asset($category->image->path) }}"
                                                class="rounded-4" alt="image">
                                            </div>
                                            @endisset
                                            <p>{{ $category->name }}</p>
                                        </div>
                                    </td>
                                    <td>{{$category->{$relationMap[$type].'_count'} }}</td>
                                    <td>
                                        @if ($category->status == 1)
                                        <span class="badge bg-success">Active</span>
                                        @else
                                        <span class="badge bg-danger">Inactive</span>
                                        @endif
                                    </td>
                                    <td>{{ $category->created_at->format('d M Y') }}</td>
                                    <td>
                                        <a href="{{ route('admin.category.edit', [$type, $category->id]) }}"
                                            class="btn btn-primary btn-sm">Edit</a>
                                        <a href="javascript:void(0)" data-url="{{ route('admin.category.destroy', [$type, $category->id]) }}" class="btn btn-danger confirm-me btn-sm">Delete</a>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <x-slot name="script">
        <x-datatable-js />
        <x-confirm-js />
    </x-slot>
</x-app-layout>
